<?php
/*
Plugin Name: Fix Mercado Pago - Itens e Valor Zero
Description: Corrige erro de "items needed" e "transaction_amount must be positive" ao usar o plugin do Mercado Pago no WooCommerce.
Version: 1.1
Author: Agência Avelar / ChatGPT
*/

add_filter('woocommerce_gateway_mercadopago_preference_data', function($preference, $order) {
    if (!$order || !($order instanceof WC_Order)) return $preference;

    // Verifica se o pedido tem produtos
    $items = $order->get_items();
    if (empty($items)) {
        wc_add_notice('Erro ao processar pagamento: o pedido não possui produtos.', 'error');
        wp_safe_redirect(wc_get_cart_url());
        exit;
    }

    // Verifica se o valor total é positivo
    if ($order->get_total() <= 0) {
        wc_add_notice('Erro ao processar pagamento: valor total do pedido é zero ou negativo.', 'error');
        wp_safe_redirect(wc_get_cart_url());
        exit;
    }

    return $preference;
}, 10, 2);
